#define TITLE   "CHEXX 1.4"
/*				Claude CHAUNIER vendredi 5 juillet 1996

Notation utilise par rrognlie pour pbmserv@eiss.erols.com:

	  1 2 3 4 5
		   6
    A   o . . . x   7
   B   . . . . . .   8
  C   . . . . . . .   9
 D   . . . . . . . .
E   x . . . . . . . o
 F   . . . . . . . .
  G   . . . . . . .
   H   . . . . . .
    I   o . . . x


	22  23  24  25  26
      32  33  34  35  36  37
    42  43  44  45  46  47  48		   -22 -21 -20
  52  53  54  55  56  57  58  59	 -12 -11 -10  -9
62  63  64  65  66  67  68  69  70	-2  -1   0  +1  +2
  73  74  75  76  77  78  79  80	  +9 +10 +11 +12
    84  85  86  87  88  89  90		   +20 +21 +22
      95  96  97  98  99 100
       106 107 108 109 110

*/

#define uchar   unsigned char
#define ushort  unsigned short
#define ulong   unsigned long

#define EMPTY   0
#define PLAYER0 1
#define PLAYER1 2
#define HOLE    4
#define OUTSIDE 8
#define GRID    16

uchar   NHoles;
uchar   NP[2];          // Nombres de Pierres des deux joueurs
uchar	NI[2];		// Nombres de Pierres Intrieures, sans voisine vide
uchar   NM[2];          // Nombres de coups valides des deux joueurs
uchar   T[133];         // Tableau de jeu
uchar	NV[133];	// Nombre de cases voisines vides  distance 1
uchar   NV1[2][256];    // Nombre de Voisins amis  distance 1
uchar   NV2[2][256];    // Nombre de Voisins amis  distance 2

uchar   h0;             // la case de la pierre qui doit sauter, ou 0 sinon
uchar   h2;             // la case d'arrive
uchar   v1;             // 6 bits disant quels voisins ont t 'retourns'

uchar   GH0[256];       // coups de la partie
uchar   GH2[256];
uchar   GV1[256];
uchar   no_coup = 0;

uchar   FH0[32];        // premiers coups  essayer durant la recherche
uchar   FH2[32];

uchar   BH0[16][16];    // meilleure variation obtenue  chaque profondeur
uchar   BH2[16][16];

uchar   Level[2];       // 0 = humain, 1,2,... = machine  profondeur 1,2,...
uchar   def_level = 1;
uchar   d;              // profondeur de la rflexion pour estimer la position
uchar	Strat[2];	// pour essayer plusieurs fonctions d'valuation
uchar	def_strat = 0;
uchar	OldStrat;
uchar	EndGame;

uchar   player = 0;
uchar   cursor = 66;

uchar   display;        // To display or not the changes made on the board
uchar	analysis = 0;
uchar   blink = 1;      //  0 pour afficher sans dlai le rsultat du coup
int	alarm = 1;	// dure du son indiquant que l'ordinateur a jou
char    x, y;

char    buf[256];       // tampon pour crire le fichier CHEXX.GAM
int     len;            // indice courant dans le prcdent


#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys\stat.h>
void *memset (void *s, int c, unsigned n);
void *memcpy (void *dest, const void *src, size_t n);
void delay(unsigned milliseconds);
void sound(unsigned frequency);
void nosound(void);


// Affichages du plateau


void compute_xy(uchar h)
{
	x = ((h-22)%10)*2 - (h-22)/10 + 6;
	y = (h-22)/10 + 2;
}


void print_grid(int on)
{
//	gotoxy(x,y-1); putch(on? ' ': ' ');
	gotoxy(x-1,y); putch(on? '(': ' ');
	gotoxy(x+1,y); putch(on? ')': ' ');
//	gotoxy(x,y+1); putch(on? ' ': ' ');
	gotoxy(x,y);
}


void print_content(uchar v)
{
	gotoxy(x,y);
	switch(v&(PLAYER0|PLAYER1|HOLE))
	{
	case EMPTY:   textcolor(DARKGRAY);  putch('.'); break;
	case PLAYER0: textcolor(LIGHTRED);  putch('o'); break;
	case PLAYER1: textcolor(LIGHTBLUE); putch('x'); break;
	case HOLE:    putch('#'); break;
	default:      putch('?');
	}
	textcolor(LIGHTGRAY);
}


void print_coord(uchar h)
{
	if(h==0) { cprintf("  "); return; }
	if(h<22) { cprintf("--"); return; }
	putch('A'+(h-22)/10);
	putch('1'+(h-22)%10);
}


void print_board(void)
{
	int     h;

	clrscr();
	textattr(DARKGRAY);
	gotoxy(33,1); cprintf(TITLE);
	textattr(LIGHTGRAY);
	for(h=22; h<111; h++)
		if((T[h]&OUTSIDE)==0)
		{       compute_xy(h);
			print_grid(0);
			print_content(T[h]);
		}
}


void ding(void)
{
	sound(440); delay(25); nosound();
}


// Dplacements de pierres


void neg_stone(uchar j, uchar h) // inverse la pierre en h au profit de j
{
	T[h] = j+1;
	if(NV[h]==0) { NI[j^1]--; NI[j]++; }

	NP[j^1]--;
#define R(H)    if(--NV1[j^1][H]==0 && T[H]==0) NM[j^1]--;
	R(h-11) R(h-10) R(h-1)
	R(h+11) R(h+10) R(h+1)

	NP[j]++;
#define R(H)    if(++NV1[j][H]==1 && T[H]==0) NM[j]++;
	R(h-11) R(h-10) R(h-1)
	R(h+11) R(h+10) R(h+1)

#define R(H)    --NV2[j^1][H]; ++NV2[j][H]; if(T[H]==0) { NM[j^1]--; NM[j]++; }
	R(h-22) R(h-21) R(h-20) R(h-12) R(h-9) R(h-2)
	R(h+22) R(h+21) R(h+20) R(h+12) R(h+9) R(h+2)

	if(display)
	{
		compute_xy(h);
		print_content(j+1);
	}
}


void add_stone(uchar j, uchar h)        // du joueur j sur l'hexagone h
{
	T[h] = j+1;
	if(NV[h]==0) NI[j]++;
	if(NV1[0][h]) NM[0]--;
	if(NV1[1][h]) NM[1]--;

	NP[j]++;
#define R(H)    if(++NV1[j][H]==1 && T[H]==0) NM[j]++;\
		if(--NV[H]==0)     { if(T[H]==PLAYER0) NI[0]++;\
				else if(T[H]==PLAYER1) NI[1]++; }
	R(h-11) R(h-10) R(h-1)
	R(h+11) R(h+10) R(h+1)

#define R(H)    ++NV2[j][H]; if(T[H]==0) NM[j]++;\
			else if(T[H]==PLAYER0) NM[0]--;\
			else if(T[H]==PLAYER1) NM[1]--;
	R(h-22) R(h-21) R(h-20) R(h-12) R(h-9) R(h-2)
	R(h+22) R(h+21) R(h+20) R(h+12) R(h+9) R(h+2)

	if(display)
	{
		compute_xy(h);
		print_content(j+1);
	}
}


void sub_stone(uchar j, uchar h)
{
	T[h] = 0;
	if(NV[h]==0) NI[j]--;
	if(NV1[0][h]) NM[0]++;
	if(NV1[1][h]) NM[1]++;

	NP[j]--;
#define R(H)    if(--NV1[j][H]==0 && T[H]==0) NM[j]--;\
		if(++NV[H]==1)     { if(T[H]==PLAYER0) NI[0]--;\
				else if(T[H]==PLAYER1) NI[1]--; }
	R(h-11) R(h-10) R(h-1)
	R(h+11) R(h+10) R(h+1)

#define R(H)    --NV2[j][H]; if(T[H]==0) NM[j]--;\
			else if(T[H]==PLAYER0) NM[0]++;\
			else if(T[H]==PLAYER1) NM[1]++;
	R(h-22) R(h-21) R(h-20) R(h-12) R(h-9) R(h-2)
	R(h+22) R(h+21) R(h+20) R(h+12) R(h+9) R(h+2)

	if(display)
	{
		compute_xy(h);
		print_content(0);
	}
}


void init_board(void)
{
	int     i, j;

	memset(T,HOLE|OUTSIDE,sizeof(T));
	memset(NV,0,sizeof(NV));
	memset(NV1,0,sizeof(NV1));
	memset(NV2,0,sizeof(NV2));
	for(i=0;i<4;i++)
		for(j=0;j<=i*10;j+=10)
		{
			T[ 67+i+j] = T[73+i+j] = T[22+i+j] =
			T[110-i-j] = T[59-i-j] = T[65-i-j] = EMPTY;
		}
	T[66] = EMPTY;
//	T[56] = T[65] = T[77] = HOLE;
	NHoles = 0;
	for(i=22;i<111;i++) if(T[i]==EMPTY)
	{
		NV[i-11]++; NV[i-10]++; NV[i-1]++;
		NV[i+11]++; NV[i+10]++; NV[i+1]++;
	}
	NP[0] = NP[1] = NI[0] = NI[1] = NM[0] = NM[1] = 0;
	add_stone(0,22); add_stone(0,70); add_stone(0,106);
	add_stone(1,26); add_stone(1,62); add_stone(1,110);
}


// Gestion d'un coup


#define IN_THOUGHT      0
#define IN_REALITY      1


void move(void)
{
	v1 = 0;
	if(h2 != 1)
	{
		if(h0) sub_stone(player,h0);
		add_stone(player,h2);

#define R(H,B)  if(T[H]==2-player) { neg_stone(player,H); v1 |= B; }
		R(h2-11,1) R(h2-10, 2) R(h2-1, 4)
		R(h2+11,8) R(h2+10,16) R(h2+1,32)
	}

	GH0[no_coup] = h0;
	GH2[no_coup] = h2;
	GV1[no_coup] = v1;
}


void unmove(void)       // Dfait un coup pour revenir en arrire
{
	h0 = GH0[no_coup];
	h2 = GH2[no_coup];
	v1 = GV1[no_coup];

	if(h2!=1)
	{
		if(h0) add_stone(player,h0);
		sub_stone(player,h2);

#define R(H,B)  if(v1&B) neg_stone(player^1,H);
		R(h2-11,1) R(h2-10, 2) R(h2-1, 4)
		R(h2+11,8) R(h2+10,16) R(h2+1,32)
	}
}


// The brain


ushort find_move(ushort, ushort);


ushort eval(ushort alpha, ushort beta)	// (la nullit est encore mal value)
{
	if(NM[0]==0 && NM[1]==0)
	{
		int	dNP = (ushort)NP[player]-(ushort)NP[player^1];
							// partie:
		if(dNP>0)	return 0xFFC0+dNP;	// gagne
		else if(dNP==0)	return 0x8000;		// nulle
		else		return 0x0040+dNP;	// perdue
	}
	if(d==0)
	{
		int	dNP = (ushort)NP[player]-(ushort)NP[player^1];
								// partie:
		if (NM[player^1]==0 && (61-NHoles-NP[player^1])>NP[player^1])
			return 0xFFC0+dNP;			// gagne
		else if(NM[player]==0 && (61-NHoles-NP[player])>NP[player])
			return 0x0040+dNP;			// perdue

		if(OldStrat)
			if(EndGame)
				return ((ushort)(0x0080+dNP)<<8)
					+NI[player]-NI[player^1];
			else	return ((ushort)(0x0080+dNP)<<8)
					+NM[player]-NM[player^1];
		else
			return ((ushort)(0x0080+(ushort)dNP
				+(ushort)NI[player]-(ushort)NI[player^1])<<8)
				+(ushort)NM[player]-(ushort)NM[player^1];
	}
	else
	{       ushort  val;

		player ^= 1; no_coup++; d--;
		val = -find_move(-beta,-alpha);
		player ^= 1; no_coup--; d++;

		return val;
	}
}


#define C0(D,I) BH0[D][I] = BH0[D-1][I]
#define C2(D,I) BH2[D][I] = BH2[D-1][I]

#define COPY_BH {if(d==0) { BH0[0][0] = h0; BH2[0][0] = h2; } else\
		 if(d==1) { C0(1,0); BH0[1][1] = h0;               \
			    C2(1,0); BH2[1][1] = h2; } else         \
		 if(d==2) { C0(2,0); C0(2,1); BH0[2][2] = h0;        \
			    C2(2,0); C2(2,1); BH2[2][2] = h2; } else  \
		 if(d==3) { C0(3,0); C0(3,1); C0(3,2); BH0[3][3] = h0; \
			    C2(3,0); C2(3,1); C2(3,2); BH2[3][3] = h2; }\
		 else     { memcpy(BH0[d],BH0[d-1],d); BH0[d][d] = h0;   \
			    memcpy(BH2[d],BH2[d-1],d); BH2[d][d] = h2; } }

// cprintf("\r\n"); cprintf("                "+d*4);
// print_coord(h0); print_coord(h2); getch();

#define FTRY {	move(); v = eval(a,b); unmove(); if(v>bv) { COPY_BH   \
		if((bv = v)>=b) { FH0[d] = h0; FH2[d] = h2; return b; }\
		if(bv>a) a = bv; } }

#define TRY  {  if(h2!=FH2[d] || h0!=FH0[d]) FTRY }


ushort find_move(ushort a, ushort b)    // alpha, beta
{
	ushort  bv = 0, v;      // valeurs estimes de la position

	if(d>=3 && kbhit()) return b;
	if(NM[player]==0) { h0 = 0; h2 = 1; FTRY return bv; }
	if(T[h2 = FH2[d]]==0)
		if(((h0 = FH0[d])==0 && NV1[player][h2]) || T[h0]==player+1)
			FTRY
	for(h2=22; h2<111; h2++) if(T[h2]==0)
	{
		if(NV1[player][h2]) { h0 = 0; TRY }
		if(NV2[player][h2])
		{
#define R(H)    if(T[H]==player+1) { h0 = H; TRY }
			R(h2-22) R(h2-21) R(h2-20) R(h2-12) R(h2-9) R(h2-2)
			R(h2+22) R(h2+21) R(h2+20) R(h2+12) R(h2+9) R(h2+2)

		}
	}
	FH0[d] = h0 = BH0[d][d];
	FH2[d] = h2 = BH2[d][d];
	return bv;
}


void think(uchar max_depth)
{
	int	x = 1;
	ushort	val;

	d = 0;
	EndGame = (NP[0]+NP[1]>=40);
	OldStrat = Strat[player]&1;
	if(analysis)
	{
		gotoxy(1,12); clreol();
		val = eval(0,0);
		if(player) val = -val;
		cprintf("%04X ",val);
		x += 5;
	}
	for(; d<max_depth; d++)
	{
		if(analysis) cprintf(" %d",d+1);
		if(d)   // on conseille avec la meilleure variante prcdente
		{
			memcpy(FH0+1,BH0[d-1],d);
			memcpy(FH2+1,BH2[d-1],d);
		}
		FH0[0] = FH2[0] = 0;    // aucun conseil pour les bourgeons
		BH0[d][d] = FH0[d];
		BH2[d][d] = FH2[d];     // meilleur coup  profondeur d-1
		val = find_move(1,0xFFFF);
		if(analysis)
		{
			gotoxy(x,12);
			print_coord(h0);
			print_coord(h2);
			if(player) val = -val;
			cprintf("%04X ",val);
			x += 9;
		}
		if(kbhit()) { d++; break; }
	}
}


// Entre d'un coup au clavier ou par rflexion de la machine


#define F1  0x3B00
#define F2  0x3C00
#define F3  0x3D00
#define F4  0x3E00
#define F5  0x3F00
#define F6  0x4000
#define F7  0x4100
#define F8  0x4200
#define F9  0x4300
#define F10 0x4400

#define FH   0x4800
#define FB   0x5000
#define FG   0x4B00
#define FD   0x4D00
#define PgUp 0x4900
#define PgDn 0x5100
#define HOME 0x4700
#define END  0x4F00
#define CFG  0x7300
#define CFD  0x7400
#define CPUp 0x8400
#define CPDn 0x7600

#define INS  0x5200

#define DEL  0x5300
#define BS   0x0008
#define ESC  0x001B
#define TAB  0x0600
#define CR   0x000D
#define SPC  0x0020


void write_coord(uchar h)
{
	if(h==0)        buf[len] = buf[len+1] = ' ';
	else if(h<22)   buf[len] = buf[len+1] = '-';
	else
	{
		buf[len  ] = 'A'+(h-22)/10;
		buf[len+1] = '1'+(h-22)%10;
	}
	len += 2;
}


int ask_move(void)
{
	int     k;
	char    dh;

	h0 = 0;
	if(no_coup>=200) Level[player] = 0;
	if(NM[0]==0 && NM[1]==0) Level[player] = 0;
	else if(NM[player]==0) { h2 = 1; return CR; } // Passe son tour
	do
	{
		if(Level[player])
		{       think(Level[player]);
			if(!kbhit())
			{
				sound(880); delay(alarm); nosound();
				return CR;
			}
			if((k = getch())==0) k = getch()<<8;
//			if(k==SPC) return CR;
			k = 0;
			h0 = 0;
			Level[player] = 0;
		}
		else
		{
			if(h0)
			{
				compute_xy(h0); print_grid(1);
				gotoxy(26,11); print_coord(h0);
			}
			gotoxy(29,11); print_coord(cursor);
			compute_xy(cursor); print_grid(1);

			if((k = getch())==0) k = getch()<<8;

			if(h0) { compute_xy(h0); print_grid(0); }
			gotoxy(26,11); cprintf("      ");
			compute_xy(cursor); print_grid(0);
		}

		dh = 0;
		switch(k)
		{
		case FH:   dh = -10; break;
		case FB:   dh = +10; break;
		case FG:   dh =  -1; break;
		case FD:   dh =  +1; break;
		case PgUp: dh = -10; break;
		case PgDn: dh = +11; break;
		case HOME: dh = -11; break;
		case END:  dh = +10; break;

		case CR:
			if(h0==0)
			{
				if(T[cursor]==player+1) h0 = cursor;
				else ding();
				break;
			}
			h2 = cursor;
			if(h2 == h0) { h0 = 0; break; }
			if(T[h2]) { ding(); break; }
			if(h2==h0-11 || h2==h0-10 || h2==h0-1
			|| h2==h0+11 || h2==h0+10 || h2==h0+1)
			{
				h0 = 0;
				return k;
			}
			if(h2==h0-22 || h2==h0-21 || h2==h0-20
			|| h2==h0+22 || h2==h0+21 || h2==h0+20
			|| h2==h0-12 || h2==h0- 9 || h2==h0- 2
			|| h2==h0+12 || h2==h0+ 9 || h2==h0+ 2) return k;
			ding();
			break;

		case '1': case '2': case '3': case '4': case '5':
		case '6': case '7': case '8': case '9':
			def_level = k-'0';
			break;

		case 'S'-'@':		// multiply sound duration
			if((alarm *= 10)==10000) alarm = 1;
			break;
		case 'A'-'@':		// show or not Analysis while thinking
			analysis ^= 1;
			break;
		case 'O'-'@':		// Old strategy evaluation
			def_strat = 1;
			break;
		case 'N'-'@':		// Normal strategy evaluation
			def_strat = 0;
			break;
		case 'B'-'@':		// Blink or not every move display
			blink ^= 1;
			break;

		case SPC:
			if(NM[0] || NM[1]) Level[player] = def_level;
			Strat[player] = def_strat;
			break;

		case INS:
		case DEL:
			if(no_coup) { ding(); break; }
		case CFG:
		case CFD:
		case CPUp:
		case CPDn:
		case F2:
		case F3:
		case ESC: return k;

		default:
			ding();
		}
		if((T[cursor+dh]&OUTSIDE)==0) cursor += dh;
	}while(1);

	return ESC;
}


// Affichage d'un coup


void blink_move(void)
{
	int     i;

	if(blink==0) return;
	for(i=1;i<7;i++)
	{
		if(h2==1)
		{
			compute_xy(65); print_grid(i&1);
			compute_xy(56); print_grid(i&1);
			compute_xy(77); print_grid(i&1);
		}else
		{
			if(h0) { compute_xy(h0); print_grid(i&1); }
			compute_xy(h2); print_grid(i&1);
		}
		delay(100);
	}
}


// Affichage de la partie


#define NB_OF_NEG(V)     ((((V)&1)!=0)+(((V)& 2)!=0)+(((V)& 4)!=0)\
			 +(((V)&8)!=0)+(((V)&16)!=0)+(((V)&32)!=0))


void print_score(void)
{
	char    x, y;

	textcolor(player? LIGHTBLUE: LIGHTRED);
	for(y=1;y<5;y++)
	{
		gotoxy(22,y);
		for(x=0;x<9;x++)
			putch("OX"[player]);
	}
	textcolor(LIGHTRED);
	gotoxy(22,6); cprintf("O  %2d pts  %2d ins  %3d mov",NP[0],NI[0],NM[0]);
	textcolor(LIGHTBLUE);
	gotoxy(22,8); cprintf("X  %2d pts  %2d ins  %3d mov",NP[1],NI[1],NM[1]);
	textcolor(LIGHTGRAY);
	gotoxy(22,10); cprintf("%3d ",no_coup);
	if(no_coup==0) cprintf("        ");
	else
	{
		print_coord(GH0[no_coup-1]);
		if(GH0[no_coup-1]) putch('-');
		else putch(' ');
		print_coord(GH2[no_coup-1]);
		putch(' ');
		if(GV1[no_coup-1]==0) cprintf("  ");
		else
		{
			putch('+');
			putch('0'+NB_OF_NEG(GV1[no_coup-1]));
		}
	}
	gotoxy(33,4);
	if(NM[0]==0 && NM[1]==0)
	{
	    if(NP[0] == NP[1])  { textcolor(YELLOW);    cprintf("DRAW!");    }
	    else if(NP[0]>NP[1]){ textcolor(LIGHTRED);  cprintf("O WINS!");}
	    else                { textcolor(LIGHTBLUE); cprintf("X WINS!");}
	    textcolor(LIGHTGRAY);
	}
	cprintf("               ");

}


// Gestion de la partie


#define P(C)    buf[len++] = C;
#define NL      { P('\r') P('\n') }
#define J(L)    while(len<(L)) P(' ')
#define SP(X)   { int j=X; while(j--) P(' ') }
#define W       { write(fh,buf,len); len = 0; }


int type_a_line(char *s)
{
	int     k, i = 0;

	gotoxy(1,12); cprintf(s);
	clreol();
	do
	{
		gotoxy(i+1,12); putch(' '); gotoxy(i+1,12);
		if((k = getch())==0) k = getch()<<8;
		switch(k)
		{
		case FG:
		case BS:
			if(i) i--;
			break;
		case CR:
			len += i;
			return CR;
		case ESC:
			return ESC;
		default:
			if(k&0xFF00 || i>79) { ding(); break; }
			putch(k);
			if(i==0) clreol();
			buf[len+i++] = (char)k;
		}
	}while(1);
}


void write_game(void)
{
	int     fh, i;

	len = 0;
	if(type_a_line("  Enter the pathname where to save the game")==ESC)
		return;
	buf[len] = 0;
	fh = open(buf, O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, S_IREAD|S_IWRITE);
	if(fh<0) { ding(); ding(); gotoxy(1,12);
		   cprintf("FILE ERROR"); clreol(); return; }

	len = 0; P(';') P(' ')
	if(type_a_line("  Enter a comment line for the game")==ESC)
		{ close(fh); return; }
	NL
	for(i=0; GH2[i]; i++)
	{
		if(i%2==0)
		{
			NL W
		}
		len += sprintf(buf+len,"%5d ",i+1);
		write_coord(GH0[i]);
		if(GH0[i]) P('-')
		else P(' ');
		write_coord(GH2[i]);
//		if(GV1[i]) { P('+') P('0'+NB_OF_NEG(GV1[i])) }
	}
	NL W
	close(fh);
}


void read_game(void)
{
#define	K	buf[0]
	int	fh, state = 0, i;

	len = 0;
	if(type_a_line("  Enter the pathname where to load the game")==ESC)
		return;
	buf[len] = 0;
	fh = open(buf, O_RDONLY|O_BINARY);
	if(fh<0) { ding(); ding(); gotoxy(1,12);
		   cprintf("FILE ERROR"); clreol(); return; }

	while(read(fh,buf,1)>0)
	{
		switch(state)
		{
		case 0:	// on n'est pas dans la partie proprement dite
			switch(K)
			{
			case '\r': case '\n': case 9: case ' ':
				state++;
			}
			break;
		case 1: // on est peut-etre dans l'espace avant le no de coup
			if(K>='0' && K<='9')
			{
				state++;
				i = K-'0';
			}
			else switch(K)
			{
			case '\r': case '\n': case 9: case ' ':
				break;
			default:
				state--;
			}
			break;
		case 2:	// on est dans un nombre prcd d'espacement
			if(K>='0' && K<='9')
				if(i>=25) state = 0;
				else i = i*10+K-'0';
			else switch(K)
			{
			case 9: case ' ':
				if(i==no_coup+1)
				{
					if(i==1)
					{
						display = 1;
						while(no_coup)
						{
							player ^= 1;
							no_coup--;
							unmove();
						}
						Level[0] = Level[1] = 0;
						GH2[0] = 0;
					}
					h0 = 0;
					state++;
					break;
				}
			case '\r': case '\n':
				state--;
				break;
			default:
				state = 0;
			}
			break;
		case 3:	// on est dans l'espace suivant le numro de coup
			if(K>='A' && K<='I')
			{
				h2 = (K-'A')*10+21;
				state++;
			}
			else switch(K)
			{
			case 9: case ' ':
				if(h0==0) break;
			case '\r': case '\n':
				state = 1;
				break;
			default:
				state = 0;
			}
			break;
		case 4: // on est aprs la lettre dnotant une case
			if(K>='1' && K<='9')
			{
				h2 += K-'0';
				state++;
			}
			else switch(K)
			{
			case '\r': case '\n': case 9: case ' ':
				state = 1;
				break;
			default:
				state = 0;
			}
			break;
		case 5:	// on vient de lire les coordonnes d'une case
			switch(K)
			{
			case '-':
				if(h0 || h2>110 || T[h2]!=player+1)
				{
					state = 0;
					break;
				}
				h0 = h2;
				state = 3;
				break;
			case '\r': case '\n': case 9: case ' ':
				if(h2>110 || T[h2]!=EMPTY
				||(h0==0 && NV1[player][h2]==0)
				||(h0 && (h0>110 || T[h0]!=player+1 || (
				   h2!=h0-22 && h2!=h0-21 && h2!=h0-20
				&& h2!=h0+22 && h2!=h0+21 && h2!=h0+20
				&& h2!=h0-12 && h2!=h0- 9 && h2!=h0- 2
				&& h2!=h0+12 && h2!=h0+ 9 && h2!=h0+ 2))))
				{
					state = 1;
					break;
				}
				move(); no_coup++; player ^= 1;
				GH2[no_coup] = 0;
				state = 1;
				break;
			default:
				state = 0;
			}
		}
	}

	close(fh);
}


void init_game(void)
{
}


void play_game(void)
{
	do
	{
		print_score();
		display = 0;
		switch(ask_move())
		{
		case CR:
			blink_move();
			display = 1; move(); no_coup++; player ^= 1;
			GH2[no_coup] = 0;
			break;
		case INS:
			if(T[cursor]&3) neg_stone(2-T[cursor],cursor);
			else
			{
				if(T[cursor])
				{
					NM[0] +=   NV2[0][cursor]
						+ (NV1[0][cursor] != 0);
					NM[1] +=   NV2[1][cursor]
						+ (NV1[1][cursor] != 0);
					T[cursor] = EMPTY; NHoles--;
				}
				add_stone(0,cursor);
			}
			print_content(T[cursor]);
			GH2[no_coup] = 0;
			break;
		case DEL:
			if(T[cursor]&3) sub_stone(T[cursor]-1,cursor);
			else if(T[cursor])
			{
				NM[0] +=   NV2[0][cursor]
					+ (NV1[0][cursor] != 0);
				NM[1] +=   NV2[1][cursor]
					+ (NV1[1][cursor] != 0);
				T[cursor] = EMPTY; NHoles--;
			}else
			{
				NM[0] -=   NV2[0][cursor]
					+ (NV1[0][cursor] != 0);
				NM[1] -=   NV2[1][cursor]
					+ (NV1[1][cursor] != 0);
				T[cursor] = HOLE; NHoles++;
			}
			print_content(T[cursor]);
			GH2[no_coup] = 0;
			break;
		case CFD:
			display = 1;
			if(GH2[no_coup]) do
			{
				h0 = GH0[no_coup];
				h2 = GH2[no_coup];
				blink_move();
				move(); no_coup++; player ^= 1;
			}while(NM[player]==0 && GH2[no_coup]);
			Level[0] = Level[1] = 0;
			break;
		case CPDn:
			display = 1;
			while(GH2[no_coup])
			{
				h0 = GH0[no_coup];
				h2 = GH2[no_coup];
				move(); no_coup++; player ^= 1;
			}
			Level[0] = Level[1] = 0;
			break;
		case CFG:
			display = 1;
			if(no_coup) do
			{
				player ^= 1; no_coup--; unmove();
			}while(NM[player]==0 && no_coup);
			Level[0] = Level[1] = 0;
			break;
		case CPUp:
			display = 1;
			while(no_coup)
			{
				player ^= 1; no_coup--; unmove();
			}
			Level[0] = Level[1] = 0;
			break;
		case F2:
			write_game();
			break;
		case F3:
			read_game();
			break;
		case ESC:
			return;
		default:
			;
		}
	}while(1);
}


void main(void)
{
	display = 0; init_board();
	init_game();
	print_board();
	play_game();
	gotoxy(1,13);
}
